import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.sourceWarehouseId) {
    newObjValue = {...newObjValue, 
      M_WarehouseSource_ID: {
        id: body.sourceWarehouseId,
        tableName: 'M_Warehouse'
      }
    }
  }
  if(body.locatorId) {
    newObjValue = {...newObjValue, 
      M_Locator_ID: {
        id: body.locatorId,
        tableName: 'M_Locator'
      }
    }
  }
  if(body.replenishTypeId) {
    newObjValue = {...newObjValue, 
      ReplenishType: {
        id: body.replenishTypeId
      }
    }
  }

  if(body.id) {
    const res: any = await fetchHelper(event, 'models/m_replenish/'+body.id, 'PUT', token, {
      isActive: body.isActive,
      Level_Min: body.levelMin,
      Level_Max: body.levelMax,
      //qtyBatchSize: body.qtyBatchSize,
      ...newObjValue,
      tableName: 'm_replenish'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})